/**
 * 
 */
package gov.va.med.mhv.usermgmt.main.service.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.LogSanitizer;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.common.data.converter.PatientConverter;
import gov.va.med.mhv.common.data.model.Patient;
import gov.va.med.mhv.usermgmt.service.MviIntegrationService;
import gov.va.med.mhv.usermgmt.service.MviTreatmentFacilityUpdator;

/**
 * @author DNS
 *
 */
public class SynchronousMviTreatmentFacilityUpdator implements MviTreatmentFacilityUpdator {
	
	private static final Log LOGGER = LogFactory.getLog(SynchronousMviTreatmentFacilityUpdator.class);
	
	@Autowired
	private PatientConverter patientConverter;
	
	@Autowired
	private MviIntegrationService mviIntegrationService;

	/* (non-Javadoc)
	 * @see gov.va.med.mhv.usermgmt.service.MviTreatmentFacilityUpdator#updateTreatmentFacilitiesForExistingPatients(gov.va.med.mhv.common.api.dto.PatientDTO)
	 */
	@Override
	public void updateTreatmentFacilitiesForExistingPatients(PatientDTO patient) throws MHVException {
		try {
			ResponseUtil<Patient> response = new ResponseUtil<Patient>();
			this.mviIntegrationService.updateTreatmentFacilitiesForExistingPatients(patientConverter.convertDTOProfile(patient), response);
			
			if(response.isFailure()) {
				throw new MHVException(response.getInfoMessages(), response.getValidationErrors(), response.getFailureMessage());
			}
		} catch(MHVException ex) {
			String msg = String.format("An error occurred while performing treatment facility update for user: %s", getNullSafeUsername(patient));
			LOGGER.error(LogSanitizer.cleanText(msg), ex);
			throw ex;
		} catch(Exception ex) {
			String msg = String.format("An error occurred while performing treatment facility update for user: %s", getNullSafeUsername(patient));
			LOGGER.error(LogSanitizer.cleanText(msg), ex);
			throw new MHVException(msg, ex);
		}
	}
	
	private String getNullSafeUsername(PatientDTO p) {
		if(p != null && p.getUserProfile() != null) {
			return p.getUserProfile().getUserName();
		}
		
		return "nullPatientOrUser";
	}

}
